/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FireworkUtil {
    public static void createRandomFireworkFromEntity(@NotNull LivingEntity owner, BlockPos blockPos) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack fireworkRocketItem = Items.f_42688_.m_7968_();
        fireworkRocketItem = FireworkUtil.addRandomFireworkData(serverLevel.m_213780_(), fireworkRocketItem);
        FireworkUtil.spawnFireworkEntity((Level)serverLevel, owner, blockPos, fireworkRocketItem);
    }

    private static void spawnFireworkEntity(Level level, LivingEntity owner, BlockPos pos, ItemStack fireworkItem) {
        FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity(owner.m_9236_(), (Entity)owner, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), fireworkItem);
        fireworkRocketEntity.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_());
        level.m_7967_((Entity)fireworkRocketEntity);
    }

    private static boolean noFireworkExplosionSet(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41782_()) {
            return false;
        }
        return !stack.m_41783_().m_128441_("Fireworks") || !stack.m_41783_().m_128469_("Fireworks").m_128441_("Explosions");
    }

    private static ItemStack addRandomFireworkData(RandomSource random, ItemStack stack) {
        ItemStack newRandomFireworkItemStack = stack.m_41777_();
        if (FireworkUtil.noFireworkExplosionSet(stack)) {
            CompoundTag compoundTagFromFireworkItemStack = stack.m_41782_() && stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
            CompoundTag fireworks = compoundTagFromFireworkItemStack.m_128441_("Fireworks") ? compoundTagFromFireworkItemStack.m_128469_("Fireworks") : new CompoundTag();
            fireworks.m_128365_("Explosions", (Tag)FireworkUtil.randomExplosions(random));
            compoundTagFromFireworkItemStack.m_128365_("Fireworks", (Tag)fireworks);
            newRandomFireworkItemStack.m_41751_(compoundTagFromFireworkItemStack);
        }
        return newRandomFireworkItemStack;
    }

    private static ListTag randomExplosions(RandomSource random) {
        ListTag list = new ListTag();
        list.add((Object)FireworkUtil.randomExplosion(random));
        if (random.m_188499_()) {
            for (int i = 0; i < random.m_188503_(2) + 1; ++i) {
                list.add((Object)FireworkUtil.randomExplosion(random));
            }
        }
        return list;
    }

    private static CompoundTag randomExplosion(RandomSource random) {
        CompoundTag EXPLOSION = new CompoundTag();
        EXPLOSION.m_128408_("Colors", FireworkUtil.randomColors(random, 1));
        EXPLOSION.m_128408_("FadeColors", FireworkUtil.randomColors(random, 5));
        EXPLOSION.m_128344_("Type", (byte)random.m_188503_(5));
        int randomFlickerTrail = random.m_188503_(10);
        if (randomFlickerTrail == 7 || randomFlickerTrail == 9) {
            EXPLOSION.m_128379_("Trail", true);
        }
        if (randomFlickerTrail == 8 || randomFlickerTrail == 9) {
            EXPLOSION.m_128379_("Flicker", true);
        }
        return EXPLOSION;
    }

    private static ArrayList<Integer> randomColors(RandomSource random, int probChance) {
        ArrayList<Integer> RANDOM_COLORS = new ArrayList<Integer>();
        RANDOM_COLORS.add(FireworkUtil.randomColor(random));
        for (int i = 0; i < random.m_188503_(3); ++i) {
            RANDOM_COLORS.add(FireworkUtil.randomColor(random));
        }
        return RANDOM_COLORS;
    }

    private static int randomColor(RandomSource random) {
        DyeColor DEFAULTED_COLOR = DyeColor.WHITE;
        String[] blockedColors = new String[]{DyeColor.BLACK.m_41065_(), DyeColor.GRAY.m_41065_(), DyeColor.LIGHT_GRAY.m_41065_(), DyeColor.WHITE.m_41065_()};
        DyeColor chosenColor = DyeColor.m_41053_((int)random.m_188503_(DyeColor.values().length));
        Set skippedIDSet = Arrays.stream(blockedColors).map(colorName -> DyeColor.m_41057_((String)colorName, (DyeColor)DEFAULTED_COLOR).m_41060_()).collect(Collectors.toSet());
        while (skippedIDSet.contains(chosenColor.m_41060_())) {
            chosenColor = DyeColor.m_41053_((int)random.m_188503_(DyeColor.values().length));
        }
        return chosenColor.m_41070_();
    }
}

